/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.world.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tv.mapper.mapperbase.world.level.block.SlopeBlock;
import tv.mapper.roadstuff.RoadStuff;
import tv.mapper.roadstuff.util.AsphaltPaintMap;
import tv.mapper.roadstuff.util.ConcretePaintMap;
import tv.mapper.roadstuff.world.item.BrushItemClient;
import tv.mapper.roadstuff.world.level.block.PaintSystem;
import tv.mapper.roadstuff.world.level.block.PaintableRoadBlock;
import tv.mapper.roadstuff.world.level.block.PaintableSlopeBlock;
import tv.mapper.roadstuff.world.level.block.RSBlockRegistry;
import tv.mapper.roadstuff.world.level.block.RotatablePaintBlock;
import tv.mapper.roadstuff.world.level.block.RotatableSlopeBlock;
import tv.mapper.roadstuff.world.level.block.state.properties.EnumPaintColor;

public class BrushItem
extends Item {
    private int paintQuantity;

    public BrushItem(Item.Properties properties, int paintQuantity) {
        super(properties);
        this.paintQuantity = paintQuantity;
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_() || !(state.m_60734_() instanceof PaintableRoadBlock);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        CompoundTag nbt = BrushItem.checkNBT(stack);
        if (nbt.m_128451_("paint") > 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 50));
            nbt.m_128405_("paint", nbt.m_128451_("paint") - 1);
            stack.m_41751_(nbt);
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag nbt = BrushItem.checkNBT(stack);
        stack.m_41751_(nbt);
        if (world.f_46443_ && !player.m_6144_()) {
            BrushItemClient.displayBrushGui(nbt.m_128451_("pattern"), nbt.m_128451_("paint"), nbt.m_128451_("color"), nbt.m_128457_("scroll"), nbt.m_128465_("favs"));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        CompoundTag nbt = BrushItem.checkNBT(context.m_43722_());
        context.m_43722_().m_41751_(nbt);
        if (context.m_43723_().m_6144_() && context.m_43725_().m_8055_(context.m_8083_()).m_60734_() instanceof PaintSystem) {
            return this.copyPattern(context.m_43725_().m_8055_(context.m_8083_()), context.m_43725_(), nbt, context.m_43723_());
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level player, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, player, list, flag);
        if (stack.m_41782_()) {
            String color = EnumPaintColor.getColorByID(stack.m_41783_().m_128451_("color")).getNameTranslated();
            if (stack.m_41783_().m_128451_("paint") == 0) {
                color = "X";
            }
            list.add((Component)new TextComponent(new TranslatableComponent("roadstuff.message.brush.gui.pattern").getString() + stack.m_41783_().m_128451_("pattern") + "; " + new TranslatableComponent("roadstuff.message.brush.gui.color").getString() + color));
            list.add((Component)new TextComponent(new TranslatableComponent("roadstuff.message.brush.gui.paint").getString() + stack.m_41783_().m_128451_("paint")));
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return BrushItem.checkNBT(stack).m_128451_("paint") > 0;
    }

    public int m_142158_(ItemStack stack) {
        return BrushItem.checkNBT(stack).m_128451_("paint") * 13 / this.getMaxPaint();
    }

    public int m_142159_(ItemStack pStack) {
        float f = Math.max(0.0f, (float)BrushItem.checkNBT(pStack).m_128451_("paint") / (float)this.getMaxPaint());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static CompoundTag checkNBT(ItemStack stack) {
        CompoundTag nbt;
        if (stack.m_41782_()) {
            nbt = stack.m_41783_();
        } else {
            int[] favorites = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
            nbt = new CompoundTag();
            nbt.m_128405_("paint", 0);
            nbt.m_128405_("pattern", 0);
            nbt.m_128405_("color", EnumPaintColor.WHITE.getId());
            nbt.m_128350_("scroll", 0.0f);
            nbt.m_128385_("favs", favorites);
        }
        return nbt;
    }

    public static InteractionResult paintLine(Direction face, BlockState state, Level world, BlockPos pos, Player player, ItemStack stack) {
        CompoundTag nbt = BrushItem.checkNBT(stack);
        stack.m_41751_(nbt);
        int pattern = nbt.m_128451_("pattern");
        int color = nbt.m_128451_("color");
        if (!world.f_46443_ && face == Direction.UP) {
            if (pattern == 0) {
                return BrushItem.removeLine(world, pos, player);
            }
            if (state.m_60734_() instanceof PaintableSlopeBlock) {
                Block newBlock;
                switch (((PaintSystem)state.m_60734_()).getMaterialType()) {
                    case 0: {
                        newBlock = RoadStuff.asphaltSlopeMap.getBlockFor(color, pattern);
                        break;
                    }
                    case 1: {
                        newBlock = RoadStuff.concreteSlopeMap.getBlockFor(color, pattern);
                        break;
                    }
                    default: {
                        return InteractionResult.PASS;
                    }
                }
                if (state.m_60734_() == newBlock) {
                    if (newBlock instanceof RotatableSlopeBlock && !world.f_46443_) {
                        switch ((Direction)state.m_61143_((Property)RotatableSlopeBlock.DIRECTION)) {
                            case NORTH: {
                                if (player.m_21205_() == stack) {
                                    world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)Direction.EAST)).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                                    break;
                                }
                                world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)Direction.WEST)).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                                break;
                            }
                            case EAST: {
                                if (player.m_21205_() == stack) {
                                    world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)Direction.SOUTH)).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                                    break;
                                }
                                world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                                break;
                            }
                            case SOUTH: {
                                if (player.m_21205_() == stack) {
                                    world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)Direction.WEST)).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                                    break;
                                }
                                world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)Direction.EAST)).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                                break;
                            }
                            case WEST: {
                                if (player.m_21205_() == stack) {
                                    world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                                    break;
                                }
                                world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)Direction.SOUTH)).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                                break;
                            }
                            default: {
                                if (player.m_21205_() == stack) {
                                    world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)Direction.EAST)).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                                    break;
                                }
                                world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)Direction.WEST)).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                                break;
                            }
                        }
                    }
                } else if (nbt.m_128451_("paint") > 0 && !world.f_46443_) {
                    if (newBlock instanceof RotatableSlopeBlock) {
                        if (player.m_21205_() == stack) {
                            world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)player.m_6350_())).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                        } else {
                            world.m_46597_(pos, (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)RotatableSlopeBlock.DIRECTION, (Comparable)player.m_6350_().m_122424_())).m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)))).m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                        }
                    } else {
                        world.m_46597_(pos, newBlock.m_49966_());
                    }
                    if (!player.m_7500_()) {
                        nbt.m_128405_("paint", nbt.m_128451_("paint") - 1);
                    }
                    world.m_5594_(null, pos, SoundEvents.f_12392_, SoundSource.BLOCKS, 0.8f, 2.0f);
                }
            } else if (state.m_60734_() instanceof PaintSystem) {
                Block newBlock;
                switch (((PaintSystem)state.m_60734_()).getMaterialType()) {
                    case 0: {
                        newBlock = RoadStuff.asphaltMap.getBlockFor(color, pattern);
                        break;
                    }
                    case 1: {
                        newBlock = RoadStuff.concreteMap.getBlockFor(color, pattern);
                        break;
                    }
                    default: {
                        return InteractionResult.PASS;
                    }
                }
                if (state.m_60734_() == newBlock) {
                    if (newBlock instanceof RotatablePaintBlock && !world.f_46443_) {
                        switch ((Direction)state.m_61143_((Property)RotatablePaintBlock.DIRECTION)) {
                            case NORTH: {
                                if (player.m_21205_() == stack) {
                                    world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)Direction.EAST));
                                    break;
                                }
                                world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)Direction.WEST));
                                break;
                            }
                            case EAST: {
                                if (player.m_21205_() == stack) {
                                    world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)Direction.SOUTH));
                                    break;
                                }
                                world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)Direction.NORTH));
                                break;
                            }
                            case SOUTH: {
                                if (player.m_21205_() == stack) {
                                    world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)Direction.WEST));
                                    break;
                                }
                                world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)Direction.EAST));
                                break;
                            }
                            case WEST: {
                                if (player.m_21205_() == stack) {
                                    world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)Direction.NORTH));
                                    break;
                                }
                                world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)Direction.SOUTH));
                                break;
                            }
                            default: {
                                if (player.m_21205_() == stack) {
                                    world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)Direction.EAST));
                                    break;
                                }
                                world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)Direction.WEST));
                                break;
                            }
                        }
                    }
                } else if (nbt.m_128451_("paint") > 0 && !world.f_46443_) {
                    if (newBlock instanceof RotatablePaintBlock) {
                        if (player.m_21205_() == stack) {
                            world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)player.m_6350_()));
                        } else {
                            world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)RotatablePaintBlock.DIRECTION, (Comparable)player.m_6350_().m_122424_()));
                        }
                    } else {
                        world.m_46597_(pos, newBlock.m_49966_());
                    }
                    if (!player.m_7500_()) {
                        nbt.m_128405_("paint", nbt.m_128451_("paint") - 1);
                    }
                    world.m_5594_(null, pos, SoundEvents.f_12392_, SoundSource.BLOCKS, 0.8f, 2.0f);
                }
            }
        }
        stack.m_41751_(nbt);
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult removeLine(Level world, BlockPos pos, Player player) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof SlopeBlock && state.m_60734_() != RSBlockRegistry.ASPHALT_SLOPE.get() && state.m_60734_() != RSBlockRegistry.CONCRETE_SLOPE.get()) {
            BlockState newBlock = BrushItem.getPaintableBlockFromMaterial(state);
            if (newBlock == null) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                world.m_46597_(pos, (BlockState)newBlock.m_61124_((Property)SlopeBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)SlopeBlock.WATERLOGGED))));
                world.m_5594_(null, pos, SoundEvents.f_11764_, SoundSource.BLOCKS, 1.0f, 1.5f);
            }
        } else if (state.m_60734_() instanceof PaintSystem && !(state.m_60734_() instanceof SlopeBlock) && state.m_60734_() != RSBlockRegistry.ASPHALT.get() && state.m_60734_() != RSBlockRegistry.CONCRETE.get()) {
            BlockState newBlock = BrushItem.getPaintableBlockFromMaterial(state);
            if (newBlock == null) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                world.m_46597_(pos, newBlock);
                world.m_5594_(null, pos, SoundEvents.f_11764_, SoundSource.BLOCKS, 1.0f, 1.5f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult copyPattern(BlockState state, Level world, CompoundTag nbt, Player player) {
        Block block = state.m_60734_();
        int materialType = ((PaintSystem)block).getMaterialType();
        AsphaltPaintMap asphaltMap = null;
        ConcretePaintMap concreteMap = null;
        if (materialType == 0) {
            asphaltMap = state.m_60734_() instanceof SlopeBlock ? RoadStuff.asphaltSlopeMap : RoadStuff.asphaltMap;
        } else if (materialType == 1) {
            concreteMap = state.m_60734_() instanceof SlopeBlock ? RoadStuff.concreteSlopeMap : RoadStuff.concreteMap;
        }
        if (asphaltMap != null || concreteMap != null) {
            if (!world.f_46443_) {
                int[] params = new int[]{0, 0};
                if (((PaintSystem)state.m_60734_()).getMaterialType() == 0) {
                    params = asphaltMap.getParamsFor(block);
                } else if (((PaintSystem)state.m_60734_()).getMaterialType() == 1) {
                    params = concreteMap.getParamsFor(block);
                }
                nbt.m_128405_("pattern", params[1]);
                player.m_5661_((Component)new TextComponent(ChatFormatting.WHITE + "Copied pattern " + params[1] + " into brush"), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static BlockState getPaintableBlockFromMaterial(BlockState state) {
        if (state.m_60734_() instanceof PaintableSlopeBlock) {
            switch (((PaintSystem)state.m_60734_()).getMaterialType()) {
                case 0: {
                    return (BlockState)((PaintableSlopeBlock)RSBlockRegistry.ASPHALT_SLOPE.get()).m_49966_().m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)));
                }
                case 1: {
                    return (BlockState)((PaintableSlopeBlock)RSBlockRegistry.CONCRETE_SLOPE.get()).m_49966_().m_61124_((Property)SlopeBlock.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SlopeBlock.LAYERS)));
                }
            }
            return null;
        }
        switch (((PaintSystem)state.m_60734_()).getMaterialType()) {
            case 0: {
                return ((PaintableRoadBlock)RSBlockRegistry.ASPHALT.get()).m_49966_();
            }
            case 1: {
                return ((PaintableRoadBlock)RSBlockRegistry.CONCRETE.get()).m_49966_();
            }
        }
        return null;
    }

    public int getMaxPaint() {
        return this.paintQuantity;
    }
}

